
#include "mkhibliba.h"

//fonction wich will be used for the h_Menu
void fct_draw_bkmk(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen) {
  hl_drawBookmark((h_File *)(hmenu->datas), i, x, y, LCD_WIDTH, screen, hmenu->font);
}

/**
 * Draw the menu for the Bookmarks
 * Note that this menu will occupy the entire screen and the screen is not restored.
 * 
 * @param hfile the file
 * @param hcfg the configuration
 * @param hlang the i18n texts
 *
 * @return the number of the choosen bookmark, NOK (-1) if none was selected
 */
short h_bookmarkMenu(h_File * hfile, h_Config * hcfg, h_I18nBookmark * hi18n) {
  
  h_Menu hmenu = {
    .nb = hfile->nb_bkmks,
    .tab = NULL,
    .level_tab = hfile->hbkmks_level,
    .datas = hfile,
    .pos_x = 3,
    .pos_y = 11,
    .width = LCD_WIDTH - 6,
    .nb_draw = (CALCULATOR ? 19 : 14),
    .font = hcfg->font_msg,
    .no_choice = 0,
    .top = 0,
    .move = 0,
    .fct_draw = fct_draw_bkmk,
    .draw_scrollbar = TRUE
  };
    
  if (hmenu.nb == 0) { //there is no bookmark
    h_drawMessage(hcfg->font_msg, hi18n->bookmarks, (const unsigned char * [1]){hi18n->no_bookmark}, 1);
    h_pause(hcfg->speed_key);
    return NOK;
  }

  clrscr();
  h_drawFrame(0, 0, LCD_WIDTH - 1, 8, LCD_SCREEN);
  h_drawFrame(0, 8, LCD_WIDTH - 1, LCD_HEIGHT - 1, LCD_SCREEN);
  hl_drawStr(hmenu.font, (LCD_WIDTH - hl_strWidth(hmenu.font, hi18n->bookmarks, FALSE, FALSE)) / 2, 2, hi18n->bookmarks, FALSE, FALSE, LCD_SCREEN);
  
draw:
  hl_drawMenu(&hmenu, LCD_SCREEN);
  do {
    h_waitSynchro();
    if (K_DOWN) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //to the bottom
        hl_goMenuBottom(&hmenu);
      } else if (K_2ND) {  //1 page scroll
        hl_goMenuPageDown(&hmenu);
      } else {
        hl_goMenuDown(&hmenu);
      }
      goto draw;
    } else if (K_UP) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //go to the top
        hl_goMenuTop(&hmenu);
      } else if (K_2ND) { //go back one page
        hl_goMenuPageUp(&hmenu);
      } else {
        hl_goMenuUp(&hmenu);
      }
      goto draw;
    } else if (K_ENTER) {  //[ENTER] : the choice is done
      h_startSynchro(hcfg->speed_key);
      return hmenu.no_choice;
    } else if (K_ESC) {  //[ESC] : cancel
      h_startSynchro(hcfg->speed_key);
      return NOK;
    } else if (K_CLEAR) {  //[CLEAR]: turn the calculator off
      off();
      h_startSynchro(hcfg->speed_key);
    } else if (K_PLUS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastUp();
    } else if (K_MOINS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastDn();
    } else {
      h_saveEnergy();
    }
  } while (TRUE);
  
}
