

#include "mkhibliba.h"

/**
 * Function that draws information on a Ti-OS variable
 * This function is designed to be used by the menu engine
 * 
 * @see h_FctDrawMenu
 */
void h_drawVAT(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen) {

  HSym * tabhsym = (HSym *)(hmenu->tab);
  unsigned char name[20];
  unsigned char buff[20];
  const unsigned char * ext = NULL;
  const unsigned char * comp = NULL;
  char * data = NULL;
  short type;
  unsigned short othtag;
  unsigned char realtag;
  SYM_ENTRY * SymPtr = DerefSym(tabhsym[i]);
  SymCpy0(name, SymPtr->name);

  if (SymPtr->flags.bits.folder) {
    ext="Folder";
    strcpy(buff, name);
  } else {
    data = HeapDeref(SymPtr->handle);
    type = h_getFileType(data);
    realtag = h_getRealTag(type);
    othtag = h_getCompTag(type);
    
    if (othtag == CUSTOM_TAG) {
      comp = "";
      switch (realtag) {
        case HTXT_TAG:
          ext = "htxt";
          break;
        default:
          ext = "???";
          break;
      }
    } else {
      switch (othtag) {
        case ZIP_TAG:
          comp = " (zip)";
          break;
        case LZFO_TAG:
          comp = " (lzfo)";
          break;
        default:
          comp = "";
          break;
      }
      switch (realtag) {
        case TEXT_TAG:
          ext = "txt";
          break;
        case PIC_TAG:
          ext = "pic";
          break;
        case STR_TAG:
          ext = "str";
          break;
        default:
          ext = "???";
          break;
      }
    }
        
    sprintf(buff, "%s.%s%s", name, ext, comp);
  }
  
  hl_drawStr(hmenu->font, x, y, buff, FALSE, FALSE, screen);

  if (!(SymPtr->flags.bits.folder)) {
    sprintf(buff, "%u o.", *(unsigned short *)data);
    hl_drawStr(hmenu->font, LCD_WIDTH - 5 - hl_strWidth(hmenu->font, buff, FALSE, FALSE), y, buff, FALSE, FALSE, screen);
  }

}
