

#include "mkhibliba.h"

/**
 * Make a HTXT file from an already parsed h_File
 * This function only create the HANDLE of the variable, not the variable
 * entry in the VAT.
 * 
 * @param hfile the file to store
 * 
 * @return the HANDLE of the future var
 */
HANDLE h_mkhtxt(h_File * hfile) {

  HANDLE h;
  short size = hfile->size_text ;
  unsigned char * ptr = NULL;
  
  size += hfile->nb_objs * sizeof(h_Object);
  size += hfile->nb_bkmks * sizeof(h_Bookmark);
  size += hfile->nb_bkmks * sizeof(h_MenuLevel);
  size += hfile->nb_bkmks * sizeof(h_ScrLine);
  
  h = HeapAlloc(size + 2 + 7);
  
  ptr = HeapDeref(h);
  
  *(unsigned short *)ptr = size + 7;
  ptr += 2;
  
  hl_lockhFile(hfile);
  
  size = hfile->nb_objs * sizeof(h_Object);
  memcpy(ptr, hfile->hobjs, size);
  ptr += size;
  size += hfile->nb_bkmks * sizeof(h_Bookmark);
  memcpy(ptr, hfile->hbkmks, size);
  ptr += size;
  size += hfile->nb_bkmks * sizeof(h_MenuLevel);
  memcpy(ptr, hfile->hbkmks_level, size);
  ptr += size;
  size += hfile->nb_bkmks * sizeof(h_ScrLine);
  memcpy(ptr, hfile->hscrlines, size);
  ptr += size;
  memcpy(ptr, "\0HTXT\0\xF8", 7);
  
  hl_unlockhFile(hfile);
  
  return h;
}
