// C Source File
// Created 10/11/2003; 23:11:05

#include "mktest.h"

/*===============================================================================================
== test
===============================================================================================*/
void test_message(const unsigned char * title, const unsigned char * (tab_message[]), short nb) {
  
  h_Font * fonttab = NULL;
  
  begintest("Message",title);
  
  short nb_font=hl_loadAllFont(&fonttab);
  h_Font * font=hl_findFont("tios1",fonttab,nb_font);

  clrscr();
  h_drawMessage(font,title,tab_message,nb);
  ngetchx();
  
  hl_unloadAllFont(fonttab,nb_font);
  
  finishtest();
}

void test_linehoriz(const unsigned char * title, short x1, short x2, short y, short length) {
  char buffer1[HEIGHT_TEST_BUFFER*length];
  char buffer2[HEIGHT_TEST_BUFFER*length];
  h_ScreenMem hscr={
    .ptr=buffer1,
    .byte_width=length
  };
  begintest("LineHoriz",title);
  
  memset(buffer1,0,HEIGHT_TEST_BUFFER*length);
  memset(buffer2,0,HEIGHT_TEST_BUFFER*length);
  
  hl_drawLineHoriz(x1,x2,y,HGRAPHMODE_BLACK,hscr);
  
  PortSet(buffer2,8*length-1,19);
  DrawLine(x1,y,x2,y,A_NORMAL);
  PortRestore();
  
  if (!testvalue("buffer",memcmp(buffer1,buffer2,HEIGHT_TEST_BUFFER*length),0)) {
    clrscr();
    DrawStr(1,80,title,A_NORMAL);
    DrawLine(x1,y+2,x2,y+2,A_NORMAL);  
    hl_drawLineHoriz(x1,x2,y,HGRAPHMODE_BLACK,LCD_SCREEN);
    ngetchx(); 
  }
  
  finishtest();
  
}

void test_linevert(const unsigned char * title, short x, short y1, short y2, short length) {
  char buffer1[HEIGHT_TEST_BUFFER*length];
  char buffer2[HEIGHT_TEST_BUFFER*length];
  h_ScreenMem hscr={
    .ptr=buffer1,
    .byte_width=length
  };
  
  begintest("LineVert",title);
  
  memset(buffer1,0,HEIGHT_TEST_BUFFER*length);
  memset(buffer2,0,HEIGHT_TEST_BUFFER*length);
  
  hl_drawLineVert(x,y1,y2,HGRAPHMODE_BLACK,hscr);
  
  PortSet(buffer2,8*length-1,19);
  DrawLine(x,y1,x,y2,A_NORMAL);
  PortRestore();
  
  if (!testvalue("buffer",memcmp(buffer1,buffer2,HEIGHT_TEST_BUFFER*length),0)) {
    clrscr();
    DrawStr(1,80,title,A_NORMAL);
    DrawLine(x+2,y1,x+2,y2,A_NORMAL);
    hl_drawLineVert(x,y1,y2,HGRAPHMODE_BLACK,LCD_SCREEN);
    ngetchx(); 
  }
  
  finishtest();
  
}


void test_copyscreen_lcd(const unsigned char * title,
                     short dst_x, short dst_y, short dst_width, short dst_height, 
                     void * src, short src_x, short src_y, short src_width, short src_height, short src_byte_length) {
  begintest("CopyScreenLcd",title);
  clrscr();
  hl_screenCopy((h_Screen){.mem={.ptr=LCD_MEM,.byte_width=30},.pos={.x=dst_x,.y=dst_y},.size={.width=dst_width,.height=dst_height}},(h_Screen){.mem={.ptr=src,.byte_width=src_byte_length},.pos={.x=src_x,.y=src_y},.size={.width=src_width,.height=src_height}});
  DrawStr(1,80,title,A_NORMAL);
  ngetchx();
  finishtest();

}

void test_copyscreen_mem(const unsigned char * title,
                     short dst_x, short dst_y, short dst_width, short dst_height, short dst_byte_length, 
                     void * src, short src_x, short src_y, short src_width, short src_height, short src_byte_length) {
  unsigned char buffer[HEIGHT_TEST_BUFFER*dst_byte_length];
  
  begintest("CopyScreenMem",title);
  memset(buffer,0,HEIGHT_TEST_BUFFER*dst_byte_length);
  hl_screenCopy((h_Screen){.mem={.ptr=buffer,.byte_width=dst_byte_length},.pos={.x=dst_x,.y=dst_y},.size={.width=dst_width,.height=dst_height}},(h_Screen){.mem={.ptr=src,.byte_width=src_byte_length},.pos={.x=src_x,.y=src_y},.size={.width=src_width,.height=src_height}});
  clrscr();
  hl_screenCopy((h_Screen){.mem=LCD_SCREEN,.pos={.x=0,.y=0},.size={.width=LCD_WIDTH,.height=LCD_HEIGHT}},(h_Screen){.mem={.ptr=buffer,.byte_width=dst_byte_length},.pos={.x=0,.y=0},.size={.width=8*dst_byte_length,.height=HEIGHT_TEST_BUFFER}});
  DrawStr(1,80,title,A_NORMAL);
  ngetchx();
  finishtest();

}

