
#ifndef __hibtypes__
#define __hibtypes__

//usually used as returned value. The Return value should usually be a positive integer, so
//NOK says there is an error
#define NOK     -1

/*===============================================================================================
========================================== Graph modes ==========================================
===============================================================================================*/
#define HGRAPHMODE_BLACK    0
#define HGRAPHMODE_WHITE    1
#define HGRAPHMODE_INVERSED 2

/*===============================================================================================
=================================== Screen specifications =======================================
===============================================================================================*/
typedef struct {
  char * ptr;
  short byte_width;
} h_ScreenMem;

typedef struct {
  short width;
  short height;
} h_ScreenSize;

typedef struct {
  short x;
  short y;
} h_ScreenPos;

typedef struct {
  h_ScreenMem mem;
  h_ScreenSize size;
  h_ScreenPos pos;
} h_Screen;

#define LCD_SCREEN (h_ScreenMem){.ptr=LCD_MEM,.byte_width=30}

/*===============================================================================================
========================================== Font types ===========================================
===============================================================================================*/
typedef struct {
  HANDLE h;
  unsigned char filename[9];
  unsigned char width;
  unsigned char upperline;
  unsigned char underline;
  unsigned char include_space;
  unsigned char size_item;
  unsigned char * tab;
} h_Font;
/*===============================================================================================
================================ Menu types and definitions =====================================
===============================================================================================*/

typedef struct {
  char level:6,
       draw:1,
       hide:1;
} h_MenuLevel;

typedef struct st_h_Menu h_Menu;

typedef void (*h_FctDrawMenu) (short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen);

struct st_h_Menu {
  short nb;  //the number of entries
  short size_item;  //the size of one entry
  unsigned char * tab;  //the table of the entries
  h_MenuLevel * level_tab;  //the levels
  void * datas; //the user's datas
//drawing config
  h_Font * font;
  unsigned char pos_x;
  unsigned char pos_y;
  unsigned char width;
  unsigned char nb_draw;
  h_FctDrawMenu fct_draw;
  BOOL draw_scrollbar;
//for the initialisation of the h_Menu
  short no_choice;
  unsigned char top;
  char move;
};


/*===============================================================================================
===================================== Logs error code ===========================================
===============================================================================================*/
#define NB_HLOG 10

typedef enum {
  HLOG_MARGIN             = 0,
  HLOG_FORMAT_LINE        = 1,
  HLOG_FONT_NOT_DEFINED   = 2,
  HLOG_SPECIAL_CARACT10   = 3,
  HLOG_SPECIAL_CARACT0    = 4,
  HLOG_SPECIAL_CARACT     = 5,
  HLOG_FORMAT_CARACT      = 6,
  HLOG_BAD_LINK            = 7,
  HLOG_BIG_MARGIN         = 8,
  HLOG_BAD_HEADER         = 9
} h_LogCode;


/*===============================================================================================
================================== Types describing a file ======================================
===============================================================================================*/
typedef struct {
// the positions of the texts associated with the header fields
  short pos_name_font[10];
  short pos_title;
  short pos_author;
  short pos_date;
  short pos_comment;
} h_Header;

typedef struct {
  h_LogCode num_error;
  unsigned short pos_txt;
} h_Log;

typedef struct {
  unsigned short pos_txt;    //position in the text
} h_Bookmark;

typedef struct {
  short no_obj;
  short no_scrline;
  short x1;
  short x2;
  char h_exp;
  char h_suffix;
} h_Link;

typedef struct {
  short inscreen:1,
        clip_x1:1,
        clip_x2:1,
        clip_y1:1,
        clip_y2:1;
  short x1;
  short x2;
  short y1;
  short y2;
} h_LinkPos;

/* The different alignments */
typedef enum {
  HALIGN_LEFT      = 0,
  HALIGN_CENTER    = 1,
  HALIGN_RIGHT     = 2,
  HALIGN_JUSTIFIED = 3
} h_Align;

/* The format of a Ti-OS Line */
typedef struct {
  unsigned char margin;      //position of the begining of the line
  h_Align        align;
} h_FrtLine;

/* The format a a caracter */
typedef struct {
  short  underline:1, dotted:1,
         conjug:1, vector:1,
         strike:1,
         link:1,
         exponent:1, suffix:1,
         wordwarp:1,
         bold:1,
         italic:1,
         inversed:1;
  char   num_font;
} h_Format;

/* The different objects */
typedef enum {
  HOBJECT_TIOS_LINE     = 0,
  HOBJECT_TEXT          = 1,
  HOBJECT_PIC           = 2, 
  HOBJECT_PPRINT        = 4,
  HOBJECT_LINK          = 6,
  HOBJECT_SEPARAT1      = 7,
  HOBJECT_SEPARAT2      = 8,
  HOBJECT_END_TEXT      = 9
} h_ObjectType;

/* The description of an Object */
typedef struct {
  h_ObjectType type;
  union {
    h_Format frt;        //for the text
    h_FrtLine frtline;   //for the begining of tios line
    struct {
      char wrong:1,
           comp:1;
      HANDLE handle;     //for pic or pprint kept in mem
    } pic;
  } datas;
  unsigned short pos_txt;
} h_Object;


/* The description a line in the screen */
typedef struct {
  unsigned short pos_txt;    //position of the first caracter in the text
  short space;    //total of space in the screen line : to justify
  short width;
  unsigned char exp_max;
  unsigned char height;      //height replace it because more used (suffix_max=height-exp_max)
} h_ScrLine;

typedef short (*FctIsComp) (HANDLE h);
typedef HANDLE (*FctUnComp) (short id, HANDLE h);

typedef struct {
  BOOL isPic;

/** Study objects **/
  const unsigned char * text;
  unsigned short  size_text;

//the hesder of the file
  h_Header hh;

  short nb_targetlinks;
  
//the tables that describe the format of the file
  short nb_tioslines;

  short     nb_objs;
  HANDLE    h_objs;
  h_Object * hobjs;

  short  nb_logs;
  HANDLE h_logs;
  h_Log * hlogs;         //the table of the pointeur of the errors messages

  short           nb_bkmks;
  HANDLE          h_bkmks;
  h_Bookmark *     hbkmks;          //the position of the bookmarks
  HANDLE          h_bkmks_level;
  h_MenuLevel *    hbkmks_level;  //the level of each bookmark
    
/** Layout objects **/
//the table of the font used in the text
  h_Font * fontptr[10];

//the table that describe the screen display of the file
  short         nb_scrlines;
  HANDLE        h_scrlines;
  h_ScrLine    * hscrlines;
  
  short   nb_links;
  HANDLE  h_links;
  h_Link * hlinks;
  
/** Layout parameters **/
  FctIsComp iscomp;
  FctUnComp uncomp;
  
  h_Font * fonttab;
  short nb_font;
  
  short linewidth;
/** The buffer datas **/
//datas use for the the drawing
  HANDLE h_buffer;
  h_Screen buffer;
    
  short drawn_height;
  
  short line_top;
  short line_bot;

  short x_offset;

/** the screen configuration **/
  h_Screen screen;
  void * screen_start;
  void * screen_end;

} h_File;

#endif

