
#ifndef __hibliba__
#define __hibliba__

/*===============================================================================================
============================================= Types =============================================
===============================================================================================*/

#define ZIP_TAG     0x0100
#define LZFO_TAG    0x0200

#define CUSTOM_TAG  0xFF00
#define HTXT_TAG    0x01
 
typedef enum {
  HCODE_NO_ERR             = 0,
  HCODE_ERR_MEM            = 1,
  HCODE_ERR_WRONG_TYPE     = 2
} h_Code;

#define HKEY_NEW_FILE -1
#define HKEY_NOKEY 0

typedef struct {
	const unsigned char * no_link;
	const unsigned char * bad_link;
} h_I18nLink;

typedef struct {
	const unsigned char * bookmarks;
	const unsigned char * no_bookmark;
} h_I18nBookmark;

typedef struct {
	const unsigned char * log;
	const char * (log_err[NB_HLOG]);
} h_I18nLog;

typedef struct {
  short speed_key;
  short speed_scroll;
  h_Font * font_msg;
} h_Config;

typedef BOOL (*h_FilterVAT) (HSym hsym);


/*===============================================================================================
========================================= Main functions ========================================
===============================================================================================*/
extern short h_readhFile(short num_line, short * bookmark, unsigned char * name_var, h_File * hfile, h_Config * hcfg, h_I18nBookmark * hi18nbookmark, h_I18nLink * hi18nlink);

extern h_Code h_loadHSym(h_File * hfile, HSym hsym, short line_width_max, BOOL allowBigObject, h_Font * fonttab, short nb_font, FctIsComp iscomp, FctUnComp uncomp);

extern void h_loadPic(h_File * hfile, HANDLE h, BITMAP * data, FctIsComp iscomp, FctUnComp uncomp);

extern short h_readPic(h_File * hfile, h_Config * hcfg);

extern HANDLE h_mkhtxt(h_File * hfile);

/*===============================================================================================
========================================= Menu functions ========================================
===============================================================================================*/
extern short h_bookmarkMenu(h_File * hfile, h_Config * hcfg, h_I18nBookmark * hi18n);

extern void h_logMenu(h_File * hfile, h_Config * hcfg, h_I18nLog * hi18n);

extern short h_chooseLink(h_File * hfile, h_Config * hcfg, h_I18nLink * hi18n);

/*===============================================================================================
========================================== Font functions ========================================
===============================================================================================*/
extern h_Font * h_setLittleFont(h_Font * fonttab, short nb_font);

extern h_Font * h_setBigFont(h_Font * fonttab, short nb_font);

/*===============================================================================================
========================================== VAT functions ========================================
===============================================================================================*/
extern BOOL h_hibfilterVAT(HSym hsym);

extern BOOL h_initMenuVAT(h_Menu * hmenu, h_Font * font, short pos_x, short pos_y, short width, short nb_draw, HANDLE * h, HANDLE * h_level, h_FilterVAT h_FilterVAT, h_FctDrawMenu fct_draw);

extern void h_drawVAT(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen);

/*===============================================================================================
======================================= Graphic functions =======================================
===============================================================================================*/
extern void h_drawFrame(short x1, short y1, short x2, short y2, h_ScreenMem screen);

extern void h_drawMessage(h_Font * font, const char * title, const unsigned char * (tab_message[]), short nb);

extern void h_restoreScreen();

/*===============================================================================================
==================================== Synchronizing functions ====================================
===============================================================================================*/
extern volatile unsigned short h_cptSynchro;

extern void h_initSynchro(unsigned short time);

extern void h_freeSynchro(void);

extern void h_pause(unsigned short time);

#define h_waitSynchro()  {	while(h_cptSynchro>0) h_saveEnergy(); }

#define h_startSynchro(time) (h_cptSynchro=time)

#define h_saveEnergy()   pokeIO(0x600005,0b10111)


/*===============================================================================================
============================================= Utils =============================================
===============================================================================================*/
extern unsigned short h_getFileType(unsigned char * data);

extern unsigned char h_filelib2tiosTable[15];

extern unsigned char h_tios2filelib(unsigned char type);

#define h_getZippedTag(data) h_filelib2tiosTable[data[2]]

#define h_getLzfoTag(data) data[4]

#define h_getCompTag(tag) (tag&0xFF00)

#define h_getRealTag(tag) (tag&0x00FF)

#define h_getAuthor(hfile)   (hfile->hh.pos_author==NOK ? NULL : hfile->text+hfile->hh.pos_author)

#define h_getComment(hfile)  (hfile->hh.pos_comment==NOK ? NULL : hfile->text+hfile->hh.pos_comment)

#define h_getDate(hfile)     (hfile->hh.pos_date==NOK ? NULL : hfile->text+hfile->hh.pos_date)

#define h_getTitle(hfile)    (hfile->hh.pos_title==NOK ? NULL : hfile->text+hfile->hh.pos_title)
	
extern void h_getStr(h_Font * font, unsigned char * str, short len, const char * title, const char * text, short lcdwidth, short lcdheight);

extern BOOL h_resizeHANDLE(HANDLE * h, short newsize, short * size, short * nb, short size_item);

#endif
