
#include "mkhibliba.h"

volatile unsigned short h_cptSynchro;
//to save the previous INT_HANDLER
INT_HANDLER OldInt1 = NULL;
INT_HANDLER OldInt5 = NULL;

//the counter
DEFINE_INT_HANDLER(IntCpt) {
  if (h_cptSynchro > 0) {
    h_cptSynchro--;
  }
//  ExecuteHandler (OldInt1);
}

/**
 * Initialise the counter for the synchronisation
 *
 * @param time the time to wait
 */
void h_initSynchro(unsigned short time) {
  h_cptSynchro = time;
  OldInt1 = GetIntVec(AUTO_INT_1);
  OldInt5 = GetIntVec(AUTO_INT_5);
  SetIntVec(AUTO_INT_1, IntCpt);
  SetIntVec(AUTO_INT_5, DUMMY_HANDLER);
}


/**
 * Stop the counter
 */
void h_freeSynchro(void) {
  SetIntVec (AUTO_INT_1, OldInt1);
  SetIntVec (AUTO_INT_5, OldInt5);
}

/**
 * Do a pause. The [ENTER] or [ESC] key quit the pause.
 *
 * @param time : the time to wait between to press of button
 */
void h_pause(unsigned short time) {
  h_waitSynchro();
  while (!(K_ENTER || K_ESC)) {
    h_saveEnergy();
  }
  h_startSynchro(time);
}
