
#include "mktest.h"

/*===============================================================================================
== test
===============================================================================================*/
void test_layout(const unsigned char * text, const unsigned char * title,
  TestLayout * testlayout) {
  
  h_File hfile;
  BOOL errparse;
  BOOL errlayout;
  h_Font * fonttab = NULL;
  short nb_font;
  short i;
  unsigned char buffer[20];
  
  begintest("Layout",title);
  
  nb_font=hl_loadAllFont(&fonttab);
    
  errparse=hl_parse(&hfile,text,strlen(text));
  errlayout=hl_layout(&hfile,LCD_WIDTH,FALSE,fonttab,nb_font,NULL,NULL);
  testvalue("returned value layout",errlayout,testlayout->err);
  testvalue("nb scrline",hfile.nb_scrlines,testlayout->nb_scrlines);
  for (i=0;i<hfile.nb_scrlines;i++) {
    sprintf(buffer,"line %d : pos_txt",i);
    testvalue(buffer,hfile.hscrlines[i].pos_txt,(*(testlayout->datas))[i][0]);
    sprintf(buffer,"line %d : space",i);
    testvalue(buffer,hfile.hscrlines[i].space,(*(testlayout->datas))[i][1]);
    sprintf(buffer,"line %d : width",i);
    testvalue(buffer,hfile.hscrlines[i].width,(*(testlayout->datas))[i][2]);
    sprintf(buffer,"line %d : exp_max",i);
    testvalue(buffer,hfile.hscrlines[i].exp_max,(*(testlayout->datas))[i][3]);
    sprintf(buffer,"line %d : height",i);
    testvalue(buffer,hfile.hscrlines[i].height,(*(testlayout->datas))[i][4]);
  }
  
  testvalue("nb link",hfile.nb_links,testlayout->nb_links);
  for (i=0;i<hfile.nb_links;i++) {
    sprintf(buffer,"link %d : no obj",i);
    testvalue(buffer,hfile.hlinks[i].no_obj,(*(testlayout->dataslink))[i][0]);
    sprintf(buffer,"link %d : no scrline",i);
    testvalue(buffer,hfile.hlinks[i].no_scrline,(*(testlayout->dataslink))[i][1]);
    sprintf(buffer,"link %d : x1",i);
    testvalue(buffer,hfile.hlinks[i].x1,(*(testlayout->dataslink))[i][2]);
    sprintf(buffer,"link %d : x2",i);
    testvalue(buffer,hfile.hlinks[i].x2,(*(testlayout->dataslink))[i][3]);
    sprintf(buffer,"link %d : exp",i);
    testvalue(buffer,hfile.hlinks[i].h_exp,(*(testlayout->dataslink))[i][4]);
    sprintf(buffer,"link %d : suffix",i);
    testvalue(buffer,hfile.hlinks[i].h_suffix,(*(testlayout->dataslink))[i][5]);
  }
  
  hl_freehFile(&hfile);
  
  hl_unloadAllFont(fonttab,nb_font);
  
  finishtest();
  
}



