

#include "mkhibliba.h"

/**
 * Draw a rounded frame in the screen
 *
 * @param x1 the x1 position of the frame
 * @param y1 the y1 position of the frame
 * @param x2 the x2 position of the frame
 * @param y2 the y2 position of the frame
 * @param screen the screen to draw in
 */
void h_drawFrame(short x1, short y1, short x2, short y2, h_ScreenMem screen) {

  hl_drawLineHoriz(x1 + 2, x2 - 2, y1, HGRAPHMODE_BLACK, screen);

  hl_drawLineHoriz(x1 + 2, x2 - 2, y2, HGRAPHMODE_BLACK, screen);

  hl_drawLineVert(x1 + 1, y1 + 1, y1 + 2, HGRAPHMODE_BLACK, screen);
  hl_drawLineVert(x1, y1 + 3, y2 - 3, HGRAPHMODE_BLACK, screen);
  hl_drawLineVert(x1 + 1, y2 - 2, y2 - 1, HGRAPHMODE_BLACK, screen);

  hl_drawLineVert(x2 - 1, y1 + 1, y1 + 2, HGRAPHMODE_BLACK, screen);
  hl_drawLineVert(x2, y1 + 3, y2 - 3, HGRAPHMODE_BLACK, screen);
  hl_drawLineVert(x2 - 1, y2 - 2, y2 - 1, HGRAPHMODE_BLACK, screen);

}


