
#include "mkhibliba.h"

struct datas {
  h_File * hfile;
  h_I18nLog * hi18n;
};

//the function which will be used by the menu
static void h_fct_drawLog(short i, short x, short y, h_Menu * hmenu, h_ScreenMem screen) {
  h_File * hfile = ((struct datas *)(hmenu->datas))->hfile;  
  h_I18nLog * hi18n = ((struct datas *)(hmenu->datas))->hi18n;  
  unsigned short pos = 0;
  unsigned short length;
  short no_tiosline = 0;
  short no_obj = 0;
  unsigned char buffer[10];
  
  hl_drawStr(hmenu->font, x, y, hi18n->log_err[hfile->hlogs[i].num_error], FALSE, FALSE, screen);

  pos = hfile->hlogs[hmenu->no_choice].pos_txt;

  memset(screen.ptr + screen.byte_width * (LCD_HEIGHT - 8), 0, screen.byte_width * 8); //clean the part of the screen

  while (no_obj < hfile->nb_objs && hfile->hobjs[no_obj].pos_txt < pos) {
    if (hfile->hobjs[no_obj].type == HOBJECT_TIOS_LINE) {
      no_tiosline++;
    }
    no_obj++;
  }
  
  if (pos != 0) {
    length = 5;
    sprintf(buffer, "l.%d :", no_tiosline);
    length += hl_drawStr(hmenu->font, 5, LCD_HEIGHT - 7, buffer, FALSE, FALSE, screen) + 1;
    while (hfile->text[pos] != 13 && hfile->text[pos] != '\0' && length < LCD_WIDTH - 15) {
      length += hl_drawChar(hmenu->font, length, LCD_HEIGHT - 7, hfile->text[pos], FALSE, FALSE, screen) + 1;
      pos++;
    }
  }
}


/**
 * Draw the log menu
 * It will use the menu routine : juste draw the error message, and if selected, it will draw the
 * part of the text where the error was found
 * Note that this menu will occupy the entire screen and the screen is not restored.
 * 
 * @param hfile the file
 * @param hcfg the config
 * @param hlang the i18n texts
 */
void h_logMenu(h_File * hfile,  h_Config * hcfg, h_I18nLog * hi18n) {

  struct datas datas = {
    .hfile = hfile,
    .hi18n = hi18n
  };
  
  h_Menu hmenu={
    .nb = hfile->nb_logs,
    .tab = NULL,
    .level_tab = NULL,
    .datas = &datas,
    .pos_x = 3,
    .pos_y = 11,
    .width = LCD_WIDTH - 6,
    .nb_draw = (CALCULATOR ? 17 : 13),
    .font = hcfg->font_msg,
    .no_choice = 0,
    .top = 0,
    .move = 0,
    .fct_draw = h_fct_drawLog,
    .draw_scrollbar = TRUE
  };

  h_initSynchro(hcfg->speed_key);
  
  clrscr();
  h_drawFrame(0, 0, LCD_WIDTH - 1, 8, LCD_SCREEN);
  h_drawFrame(0, 9, LCD_WIDTH - 1, LCD_HEIGHT - 10, LCD_SCREEN);
  hl_drawStr(hmenu.font,(LCD_WIDTH - hl_strWidth(hmenu.font, hi18n->log, FALSE, FALSE)) / 2, 2, hi18n->log, FALSE, FALSE, LCD_SCREEN);
draw:
  hl_drawMenu(&hmenu, LCD_SCREEN);
  do {  
    h_waitSynchro();
    if (K_DOWN) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //to the bottom
        hl_goMenuBottom(&hmenu);
      } else if (K_2ND) {  //1 page scroll
        hl_goMenuPageDown(&hmenu);
      } else {
        hl_goMenuDown(&hmenu);
      }
      goto draw;
    } else if (K_UP) {
      h_startSynchro(hcfg->speed_key);
      if (K_DIAM) {  //go to the top
        hl_goMenuTop(&hmenu);
      } else if (K_2ND) { //go back one page
        hl_goMenuPageUp(&hmenu);
      } else {
        hl_goMenuUp(&hmenu);
      }
      goto draw;
    } else if (K_ESC) {  //[ESC] : cancel
      h_startSynchro(hcfg->speed_key);
      break;
    } else if (K_CLEAR) {  //[CLEAR]: turn the calculator off
      h_startSynchro(hcfg->speed_key);
      off();
    } else if (K_PLUS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastUp();
    } else if (K_MOINS && K_DIAM) {
      h_startSynchro(hcfg->speed_key);
      OSContrastDn();
    } else {
      h_saveEnergy();
    }
  } while (TRUE);
  
  h_waitSynchro();
  h_freeSynchro();

}

