
#include "mktest.h"

//#define TEST_PARSE_HEADER
//#define TEST_PARSE_BKMK
//#define TEST_PARSE_FRTLINE
//#define TEST_PARSE_OBJLINE
//#define TEST_PARSE_TIOSLINE
//#define TEST_PARSE
//#define TEST_LAYOUT
//#define TEST_LINEHORIZ
//#define TEST_LINEVERT
//#define TEST_FONTCHAR
//#define TEST_FONTSTR
//#define TEST_FONTOTHER
//#define TEST_FONTSPEED
//#define TEST_MESSAGE
//#define TEST_COPYSCREENLCD
//#define TEST_COPYSCREENMEM
//#define TEST_DRAWLINE
//#define TEST_DRAWPAGE
//#define TEST_KEYMENU
//#define TEST_DRAWMENU
//#define TEST_DRAWMENUVAT
//#define TEST_LINK
#define TEST_READ

#define NB_TEST 3
TestDatas * testdatas[NB_TEST] = {/*
  &testdatas01_simple,
  &testdatas02_2lines,
  &testdatas03_font,
  &testdatas04_underline,
  &testdatas05_dotted,
  &testdatas06_vectconj,
  &testdatas07_expsuffix,
  &testdatas08_expsuffixfont,
  &testdatas09_italic,
  &testdatas10_bold,
  &testdatas11_inversed,
  &testdatas12_strike,*/
  &testdatas13_link,
  &testdatas14_link2lines,/*
  &testdatas15_align,
  &testdatas16_margin,
  &testdatas17_title,
  &testdatas18_bkmk,
  &testdatas19_bkmktitle,
  &testdatas20_bkmklevels,
  &testdatas21_emptylines,
  &testdatas22_bigline,
  &testdatas23_wwbigline,
  &testdatas24_wwbiglinenospace,
  &testdatas25_pprint,
  &testdatas26_pic,
  &testdatas27_separat,
  &testdatas28_text,
  &testdatas29_textfont,
  &testdatas30_textformat,
  &testdatas31_bigtext,*/
  &testdatas32_bigtextlink
};

short width = 160;
//short width = 240;
#define lcd_frame 0,0,LCD_WIDTH,LCD_HEIGHT

unsigned char picdata[]={
  0,8,0,8,
  0b11111111,
  0b10100101,
  0b11011011,
  0b10100101,
  0b10100101,
  0b11011011,
  0b10100101,
  0b11111111,
  0,PIC_TAG
};
  
long testMemIni;

short nb_drawn;
BOOL bug;

BOOL testvalue(const unsigned char * name_var, short calc_value, short wanted_value) {

  if (calc_value==wanted_value)
    return TRUE;
  
  printf("\n%s : want %d have %d",name_var,wanted_value,calc_value);
  bug=TRUE;
  nb_drawn++;
  if (nb_drawn%10==0) {
    ngetchx();
    nb_drawn=0;
  }
  return FALSE;
}

BOOL teststring(const unsigned char * name_var, const unsigned char * calc_string, const unsigned char * wanted_string) {

  if (wanted_string==NULL) {
    if (calc_string==NULL)
      return TRUE;
    printf("\n%s : want NULL have %s",name_var,calc_string);
  } else {
    if (calc_string==NULL) {
      printf("\n%s : want %s have NULL",name_var,wanted_string);
    } else {
      short cmp = strcmp(calc_string,wanted_string);
      if (cmp==13 || cmp==0)
        return TRUE;
      printf("\n%s : want %s have %s",name_var,wanted_string,calc_string);
    }
  }  

  bug=TRUE;
  nb_drawn++;
  
  if (nb_drawn%10==0) {
    ngetchx();
    nb_drawn=0;
  }
  return FALSE;
}

void begintest(const unsigned char * main_name,const unsigned char * sub_name) {
  FontSetSys(F_4x6);
  testMemIni=HeapAvail();
  printf("\nBegining test %s '%s'...",main_name,sub_name);
  bug=FALSE;
}

void finishtest(void) {
  FontSetSys(F_4x6);
  long mem=HeapAvail();
  if (bug) {
    printf("\n...there were errors");
  } else {
    printf("done.");
  }
  if (mem!=testMemIni)
    printf("\n*** Memory leak : %ld bytes lost",testMemIni-mem);  
  if (bug || mem!=testMemIni) {
    ngetchx();
    nb_drawn=0;
  }
}

// Main Function
void _main(void)
{
  
  FontSetSys(F_4x6);
  clrscr();
  nb_drawn=0;
  short j=0;
  
  FILE * file=fopen("main\\picture","wb");
  fwrite(picdata,1,14,file);
  fclose(file);

//  test_sizestruct();

#ifdef TEST_PARSE_HEADER
  //returned_value,pos_title,pos_author,pos_comment,pos_date,pos_txt,pos_font[10]
  test_parse_header(" some text","no header",TRUE,NOK,NOK,NOK,NOK,0,(short[10]){ NOK,0,0,0,NOK,NOK,NOK,NOK,NOK,NOK});
  test_parse_header(" \251TITLE=the title","title",TRUE,8,NOK,NOK,NOK,17,(short[10]){ NOK,0,0,0,NOK,NOK,NOK,NOK,NOK,NOK});
  test_parse_header(" \251TITLE=the title\r \251AUTHOR=hibou\r \251blabla\r \251DATE=10/11/2003\r \251COMMENT=super\r blabla","title,author,bad,date,comment",TRUE,8,27,70,49,76,(short[10]){ NOK,0,0,0,NOK,NOK,NOK,NOK,NOK,NOK});
  test_parse_header(" \251TITLE=the title\r \251#4=font4\r \251DATE=10/11/2003\r \251#1=font1\r blabla","title,font4,date,font1",TRUE,8,NOK,NOK,36,58,(short[10]){ NOK,52,0,0,23,NOK,NOK,NOK,NOK,NOK});
#endif

#ifdef TEST_PARSE_BKMK
  //returned_value,study_pos_txt,nb_bookmks,bkmk_pos_txt,level
  test_parse_bkmk("\014a simple bookmark\r blablabla","simple",TRUE,1,1,0,0);
  test_parse_bkmk("\014&Ttitle bookmark&Tsome text bookmarked\r blablabla","def title",TRUE,19,1,3,0);
  test_parse_bkmk("\014&T3title bookmark&Tsome text bookmarked\r blablabla","def titre & level",TRUE,20,1,4,3);
#endif

#ifdef TEST_PARSE_FRTLINE
  //returned_value,pos_txt,margin,align
  test_parse_frtline("blablabla\r hihihihi","none",TRUE,0,0,HALIGN_LEFT);
  test_parse_frtline("&Cblablabla\r hihihihi","center",TRUE,2,0,HALIGN_CENTER);
  test_parse_frtline("&,blabla\r hihihihi","margin",TRUE,2,10,HALIGN_LEFT);
  test_parse_frtline("&M053blabla\r hihihihi","custom margin",TRUE,5,53,HALIGN_LEFT);
  test_parse_frtline("&M053&R&&blabla\r hihihihi","custom margin,right,&&",TRUE,7,53,HALIGN_RIGHT);
#endif

#ifdef TEST_PARSE_OBJLINE
  //returned_value,pos_txt,type
  test_parse_objline("&E2+2=5\r hihihihi","expression",TRUE,8,HOBJECT_PPRINT,TRUE);
  test_parse_objline("&Ppic\r hihihihi","pic",TRUE,6,HOBJECT_PIC,TRUE);
  test_parse_objline("&-blabla","separation",TRUE,8,HOBJECT_SEPARAT1,TRUE);
#endif
  
#ifdef TEST_PARSE_TIOSLINE
  //return,pos_txt,nb_obj,{type,pos_txt,num_font,underline,dotted,vector,conjug,strike,exponent,suffix,link,italic,bold,inversed}
  test_parse_tiosline("blablabla\r hihihihi","none",TRUE,10,1,(short[1][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}});  
  test_parse_tiosline("blab#Ulabla\r hihihihi","underline",TRUE,12,2,(short[2][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,4,2,1,0,0,0,0,0,0,0,0,0,0}});
  test_parse_tiosline("bla#Ubla#Nbla\r hihihihi","underline,dotted",TRUE,14,3,(short[3][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,3,2,1,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,8,2,0,1,0,0,0,0,0,0,0,0,0}});
  test_parse_tiosline("bla#Vbla#Vbla\r hihihihi","vector",TRUE,14,3,(short[3][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,3,2,0,0,1,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,8,2,0,0,0,0,0,0,0,0,0,0,0}});
  test_parse_tiosline("bla##blabla\r hihihihi","##",TRUE,12,1,(short[1][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}});
  test_parse_tiosline("bla#1blabla\r hihihihi","font 1",TRUE,12,2,(short[2][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,3,1,0,0,0,0,0,0,0,0,0,0,0}});
  test_parse_tiosline("bla#Ebla#Dbla\r hihihihi","exponent,suffix",TRUE,14,3,(short[3][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,3,2,0,0,0,0,0,1,0,0,0,0,0}, {HOBJECT_TEXT,8,2,0,0,0,0,0,0,1,0,0,0,0}});
  test_parse_tiosline("bla#Ltarget#Llien#Lbla\r hihihihi","link",TRUE,23,4,(short[4][14]){ {HOBJECT_TEXT,0,2,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_LINK,3,0,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,13,2,0,0,0,0,0,0,0,1,0,0,0}, {HOBJECT_TEXT,17,2,0,0,0,0,0,0,0,0,0,0,0}});
  test_parse_tiosline("#Llink#Lbl#Uab##la#L\r text","link,font1,##",TRUE,21,3,(short[3][14]){ {HOBJECT_LINK,0,0,0,0,0,0,0,0,0,0,0,0,0}, {HOBJECT_TEXT,8,2,0,0,0,0,0,0,0,1,0,0,0}, {HOBJECT_TEXT,10,2,1,0,0,0,0,0,0,1,0,0,0}});
#endif

/*
  const unsigned char * text=;
  const unsigned char * title=;
  h_Code errparse=HCODE_NO_ERR;
  short nb_objs=;
  short tabtestparse[][16]={
    
  };
  const unsigned char * htitle=NULL;
  const unsigned char * hauthor=NULL;
  const unsigned char * hdate=NULL;
  const unsigned char * hcomment=NULL;
  short nb_bkmks=0;
  short bkmks[0][2];
  h_Code errlayout=HCODE_NO_ERR;
  short nb_scrlines=;
  short tabtestlayout[][5]={
  
  };
  short nb_scrlinks=0;
  short tabtestlink[0][6];
*/

#ifdef TEST_PARSE
  for (j=0;j<NB_TEST;j++)
    test_parse_all(testdatas[j]->text,testdatas[j]->title,&(testdatas[j]->parse));    
#endif

#ifdef TEST_LAYOUT
  for (j=0;j<NB_TEST;j++)
    test_layout(testdatas[j]->text,testdatas[j]->title,&(testdatas[j]->layout));    
#endif  
  
#ifdef TEST_LINEHORIZ
  test_linehoriz("1 byte",8,15,1,30);
  test_linehoriz("2 bytes",8,23,1,30);
  test_linehoriz("start half",11,23,1,30);
  test_linehoriz("end half",8,20,1,30);
  test_linehoriz("star & end half",11,20,1,30);
  test_linehoriz("1 bit",11,11,1,30);
  test_linehoriz("2 x 1 bit",7,8,1,30);
  test_linehoriz("big line",7,53,1,30);
  test_linehoriz("chg length",7,53,1,10);
#endif

#ifdef TEST_LINEVERT
  test_linevert("1 bit",10,1,1,30);
  test_linevert("simple",10,1,5,30);
  test_linevert("chg length",10,1,5,10);
#endif

#ifdef TEST_FONTCHAR
  test_fontchar("font1",0,0,'h',0,3,FALSE,FALSE);
  test_fontchar("font2",0,0,'h',1,5,FALSE,FALSE);
  test_fontchar("font3",0,0,'h',2,7,FALSE,FALSE);
  test_fontchar("font1 italic",0,0,'h',0,3,TRUE,FALSE);
  test_fontchar("font2 italic",0,0,'h',1,5,TRUE,FALSE);
  test_fontchar("font3 italic",0,0,'h',2,7,TRUE,FALSE);
  test_fontchar("font1 bold",0,0,'h',0,4,FALSE,TRUE);
  test_fontchar("font2 bold",0,0,'h',1,6,FALSE,TRUE);
  test_fontchar("font3 bold",0,0,'h',2,8,FALSE,TRUE);
#endif

#ifdef TEST_FONTSTR
  test_fontstr("font1",0,0,"hello",0,17,FALSE,FALSE);
  test_fontstr("font2",0,0,"hello",1,29,FALSE,FALSE);
  test_fontstr("font3",0,0,"hello",2,39,FALSE,FALSE);
  test_fontstr("font1 italic",0,0,"hello",0,17,TRUE,FALSE);
  test_fontstr("font2 italic",0,0,"hello",1,29,TRUE,FALSE);
  test_fontstr("font3 italic",0,0,"hello",2,39,TRUE,FALSE);
  test_fontstr("font1 bold",0,0,"hello",0,22,FALSE,TRUE);
  test_fontstr("font2 bold",0,0,"hello",1,34,FALSE,TRUE);
  test_fontstr("font3 bold",0,0,"hello",2,44,FALSE,TRUE);
#endif

#ifdef TEST_FONTOTHER
  test_fontother();
#endif

#ifdef TEST_FONTSPEED
  test_fontspeed("font1",0,FALSE,FALSE);
  test_fontspeed("font2",1,FALSE,FALSE);
  test_fontspeed("font3",2,FALSE,FALSE);
  test_fontspeed("italic 1",0,TRUE,FALSE);
  test_fontspeed("italic 2",1,TRUE,FALSE);
  test_fontspeed("italic 3",2,TRUE,FALSE);
  test_fontspeed("bold 1",0,FALSE,TRUE);
  test_fontspeed("bold 2",1,FALSE,TRUE);
  test_fontspeed("bold 3",2,FALSE,TRUE);
#endif


#ifdef TEST_MESSAGE
  test_message("simple",(const unsigned char * [1]){"message"},1);
  test_message("double",(const unsigned char * [2]){"message 1","message 2"},2);
  test_message("triple",(const unsigned char * [3]){"message 1","message 2","message 3"},3);
#endif

#ifdef TEST_COPYSCREENLCD
  test_copyscreen_lcd("simple",0,0,LCD_WIDTH,LCD_HEIGHT,picdata+4,0,0,8,8,0);
  test_copyscreen_lcd("x offset",10,0,LCD_WIDTH,LCD_HEIGHT,picdata+4,0,0,8,8,0);
  test_copyscreen_lcd("y offset",0,10,LCD_WIDTH,LCD_HEIGHT,picdata+4,0,0,8,8,0);
  test_copyscreen_lcd("pic offset",0,0,LCD_WIDTH,LCD_HEIGHT,picdata+4,2,2,6,6,1);
  test_copyscreen_lcd("pic part",0,0,LCD_WIDTH,LCD_HEIGHT,picdata+4,2,2,4,4,1);
  test_copyscreen_lcd("hard",5,5,LCD_WIDTH,LCD_HEIGHT,picdata+4,2,2,4,4,1);
#endif
  
#ifdef TEST_COPYSCREENMEM
  test_copyscreen_mem("simple",0,0,LCD_WIDTH,LCD_HEIGHT,2,picdata+4,0,0,8,8,0);
  test_copyscreen_mem("x offset",5,0,LCD_WIDTH,LCD_HEIGHT,2,picdata+4,0,0,8,8,0);
  test_copyscreen_mem("y offset",0,5,LCD_WIDTH,LCD_HEIGHT,2,picdata+4,0,0,8,8,0);
  test_copyscreen_mem("pic offset",0,0,LCD_WIDTH,LCD_HEIGHT,2,picdata+4,2,2,6,6,1);
  test_copyscreen_mem("pic part",0,0,LCD_WIDTH,LCD_HEIGHT,2,picdata+4,2,2,4,4,1);
  test_copyscreen_mem("hard",5,5,LCD_WIDTH,LCD_HEIGHT,2,picdata+4,2,2,4,4,1);
#endif
  
#ifdef TEST_DRAWLINE
  for (j=0;j<NB_TEST;j++)
    test_drawline(testdatas[j]->text,testdatas[j]->title);    
#endif

#ifdef TEST_DRAWPAGE
  for (j=0;j<NB_TEST;j++)
    test_drawpage(testdatas[j]->text,testdatas[j]->title,width,lcd_frame);    
#endif


#ifdef TEST_KEYMENU
  test_menukey("down",5,5,0,0,1,0,hl_goMenuDown,NULL);
  test_menukey("down 1",5,1,0,0,1,1,hl_goMenuDown,NULL);
  
  test_menukey("up",5,5,1,0,0,0,hl_goMenuUp,NULL);
  test_menukey("up 1",5,1,1,1,0,0,hl_goMenuUp,NULL);
  
  test_menukey("bottom",5,5,0,0,4,0,hl_goMenuBottom,NULL);
  test_menukey("bottom size>nb_draw",5,3,0,0,4,2,hl_goMenuBottom,NULL);
  
  test_menukey("top",5,5,4,0,0,0,hl_goMenuTop,NULL);
  test_menukey("top size>nb_draw",5,3,4,2,0,0,hl_goMenuTop,NULL);
  
  test_menukey("page down",5,3,0,0,3,2,hl_goMenuPageDown,NULL);
  test_menukey("page down 2",5,3,2,0,4,2,hl_goMenuPageDown,NULL);
  test_menukey("page up",5,3,4,2,1,0,hl_goMenuPageUp,NULL);
  test_menukey("page up 2",5,3,2,2,0,0,hl_goMenuPageUp,NULL);
  
  test_menukey("sub",5,3,0,0,0,0,hl_goSubMenu,(h_MenuLevel[5]){{0,0,1},{0,0,1},{1,0,1},{2,0,1},{1,0,1}});
  test_menukey("upper",5,3,0,0,0,0,hl_goUpperMenu,(h_MenuLevel[5]){{0,0,1},{0,0,1},{1,0,1},{2,0,1},{1,0,1}});
#endif


#ifdef TEST_DRAWMENU
  test_drawmenu("2 items",2,3,0,0,FALSE,NULL,NULL);
  test_drawmenu("5 items",5,5,0,0,FALSE,NULL,NULL);
  test_drawmenu("start=1",5,5,1,0,FALSE,NULL,NULL);
  test_drawmenu("nb>draw",5,2,0,0,FALSE,NULL,NULL);
  test_drawmenu("nb>draw 2",5,2,3,2,FALSE,NULL,NULL);
  
  test_drawmenu("level expanded",5,5,0,0,FALSE,(h_MenuLevel [5]){
    {.level=0,.hide=0,.draw=1},
    {.level=0,.hide=0,.draw=1},
    {.level=1,.hide=0,.draw=1},
    {.level=2,.hide=0,.draw=1},
    {.level=1,.hide=0,.draw=1}},NULL);
  test_drawmenu("level reduced",5,5,0,0,FALSE,(h_MenuLevel [5]){
    {.level=0,.hide=0,.draw=1},
    {.level=0,.hide=0,.draw=1},
    {.level=1,.hide=0,.draw=1},
    {.level=2,.hide=1,.draw=0},
    {.level=1,.hide=0,.draw=1}},NULL);
  test_drawmenu("level more reduced",5,5,0,0,FALSE,(h_MenuLevel[5]){
    {.level=0,.hide=0,.draw=1},
    {.level=0,.hide=0,.draw=1},
    {.level=1,.hide=1,.draw=0},
    {.level=2,.hide=1,.draw=0},
    {.level=1,.hide=1,.draw=0}},NULL);

  test_drawmenu("drawperso1 start=1",5,5,1,0,FALSE,NULL,test_drawmenu_perso1);
  test_drawmenu("drawperso1 nb>draw",5,2,0,0,FALSE,NULL,test_drawmenu_perso1);
  test_drawmenu("drawperso2 start=1",5,5,1,0,FALSE,NULL,test_drawmenu_perso2);
  test_drawmenu("drawperso2 nb>draw",5,2,0,0,FALSE,NULL,test_drawmenu_perso2);
#endif

#ifdef TEST_DRAWMENUVAT
  test_drawmenuvat();
#endif

#ifdef TEST_LINK
  //links, nblink, scrlines, top, bottom, x, y, width, height
  //no_line, link_prev, link_next
  //no_link, prev_link, next_link, first, last
  test_link_nav("simple",(h_Link[]){
    {.no_obj=1,.no_scrline=1,.x1=0,.x2=0,.h_exp=0,.h_suffix=0},
    {.no_obj=2,.no_scrline=2,.x1=0,.x2=0,.h_exp=0,.h_suffix=0},
    {.no_obj=3,.no_scrline=3,.x1=0,.x2=0,.h_exp=0,.h_suffix=0},
  },3,(h_ScrLine[]){
    {.height=5, .exp_max=5},
    {.height=5, .exp_max=5},
    {.height=5, .exp_max=5},
    {.height=5, .exp_max=5},
    {.height=5, .exp_max=5}
  },0,4,0,0,LCD_WIDTH,LCD_HEIGHT,1,1,1,0,0,2,0,2);
  test_link_nav("one",(h_Link[]){
    {.no_obj=1,.no_scrline=1,.x1=0,.x2=0,.h_exp=0,.h_suffix=0}
  },1,(h_ScrLine[]){
    {.height=5, .exp_max=5},
    {.height=5, .exp_max=5},
    {.height=5, .exp_max=5}
  },0,2,0,0,LCD_WIDTH,LCD_HEIGHT,1,0,0,0,NOK,NOK,0,0);
#endif

#ifdef TEST_READ
  for (j=0;j<NB_TEST;j++)
    test_read(testdatas[j]->text,testdatas[j]->title,width,lcd_frame);    
#endif


//  testmenuVAT();
//  testmkhtxt();
//  testmessage();


  SymDel(SYMSTR("main\\picture")); 
  
  printf("\n*** The End ***");
  ngetchx();

}

