// C Source File
// Created 10/11/2003; 23:11:05
#include "mktest.h"

void test_drawline(const unsigned char * text, const unsigned char * title) {
  h_File hfile;
  h_Font * fonttab = NULL;
  
  begintest("Draw line",title);
  
  short nb_font = hl_loadAllFont(&fonttab);
  short i;
  unsigned short h2,h=10;
  
  hl_parse(&hfile,text,strlen(text));
  hl_layout(&hfile,LCD_WIDTH,FALSE,fonttab,nb_font,NULL,NULL);
  clrscr();
  
  for (i=0;i<hfile.nb_scrlines;i++) {
    hl_drawLineHoriz(0,LCD_WIDTH-1,h,HGRAPHMODE_BLACK,hfile.buffer.mem);
    h++;
    h2=h;
    hdrawLine(i,0,h,hfile.buffer.size,hfile.buffer.mem,&hfile);
    h+=hfile.hscrlines[i].height;
    hl_drawLineVert(hfile.hscrlines[i].width,h2,h,HGRAPHMODE_BLACK,hfile.buffer.mem);
    if (h>LCD_HEIGHT-10)
      break;
  }
  hl_drawLineHoriz(0,LCD_WIDTH-1,h,HGRAPHMODE_BLACK,hfile.buffer.mem);
  
  hl_initScreen(&hfile,LCD_MEM,0,0,LCD_WIDTH,LCD_HEIGHT-10);
  hl_refreshScreen((&hfile));
  DrawStr(0,0,title,A_NORMAL);
  ngetchx();
  
  hl_unloadAllFont(fonttab,nb_font);
  hl_freehFile(&hfile);
  
  finishtest();
}

void test_drawpage(const unsigned char * text, const unsigned char * title,
              short width, short x, short y, short lcdwidth, short lcdheight) {
  h_File hfile;
  BOOL errparse;
  BOOL errlayout;
  h_Font * fonttab = NULL;
  
  begintest("Draw page",title);
  
  short nb_font = hl_loadAllFont(&fonttab);

  clrscr();
  errparse=hl_parse(&hfile,text,strlen(text));
  errlayout=hl_layout(&hfile,width,FALSE,fonttab,nb_font,NULL,NULL);
  
  clrscr();
  hl_drawPage(0,&hfile);
  hl_initScreen(&hfile,LCD_MEM,x,y,lcdwidth,lcdheight);
  hl_refreshScreen((&hfile));

  ngetchx();
  
  hl_freehFile(&hfile);
  hl_unloadAllFont(fonttab,nb_font);
  
  finishtest();
}

